/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import java.text.CharacterIterator;

public class UCharacterIterator
implements Cloneable {
    public static final int DONE = -1;
    private String text;
    private int currentIndex;

    private UCharacterIterator(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.text = string;
        this.currentIndex = 0;
    }

    protected UCharacterIterator() {
    }

    public static final UCharacterIterator getInstance(String string) {
        return new UCharacterIterator(string);
    }

    public static final UCharacterIterator getInstance(CharacterIterator characterIterator) {
        return new CharacterIteratorWrapper(characterIterator);
    }

    public int current() {
        if (this.currentIndex < this.text.length()) {
            return this.text.charAt(this.currentIndex);
        }
        return -1;
    }

    public int getLength() {
        return this.text.length();
    }

    public int getIndex() {
        return this.currentIndex;
    }

    public int next() {
        if (this.currentIndex < this.text.length()) {
            return this.text.charAt(this.currentIndex++);
        }
        return -1;
    }

    public int nextCodePoint() {
        int n = this.next();
        if (Character.isHighSurrogate((char)n)) {
            int n2 = this.next();
            if (Character.isLowSurrogate((char)n2)) {
                return Character.toCodePoint((char)n, (char)n2);
            }
            if (n2 != -1) {
                this.previous();
            }
        }
        return n;
    }

    public int previous() {
        if (this.currentIndex > 0) {
            return this.text.charAt(--this.currentIndex);
        }
        return -1;
    }

    public int previousCodePoint() {
        int n = this.previous();
        if (Character.isLowSurrogate((char)n)) {
            int n2 = this.previous();
            if (Character.isHighSurrogate((char)n2)) {
                return Character.toCodePoint((char)n2, (char)n);
            }
            if (n2 != -1) {
                this.next();
            }
        }
        return n;
    }

    public void setIndex(int n) {
        if (n < 0 || n > this.text.length()) {
            throw new IllegalArgumentException("Invalid index");
        }
        this.currentIndex = n;
    }

    public int getBeginIndex() {
        return 0;
    }

    public void setToLimit() {
        this.setIndex(this.getLength());
    }

    public int moveIndex(int n) {
        int n2 = Math.max(0, Math.min(this.getIndex() + n, this.getLength()));
        this.setIndex(n2);
        return n2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static class CharacterIteratorWrapper
    extends UCharacterIterator {
        private CharacterIterator iterator;

        CharacterIteratorWrapper(CharacterIterator characterIterator) {
            if (characterIterator == null) {
                throw new NullPointerException();
            }
            this.iterator = characterIterator;
        }

        public int current() {
            char c = this.iterator.current();
            if (c == '\uffff') {
                return -1;
            }
            return c;
        }

        public int getLength() {
            return this.iterator.getEndIndex() - this.iterator.getBeginIndex();
        }

        public int getIndex() {
            return this.iterator.getIndex();
        }

        public int next() {
            char c = this.iterator.current();
            this.iterator.next();
            if (c == '\uffff') {
                return -1;
            }
            return c;
        }

        public int previous() {
            char c = this.iterator.previous();
            if (c == '\uffff') {
                return -1;
            }
            return c;
        }

        public void setIndex(int n) {
            this.iterator.setIndex(n);
        }

        public int getBeginIndex() {
            return this.iterator.getBeginIndex();
        }
    }
}

