/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.image.SunVolatileImage;
import sun.awt.windows.WComponentPeer;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.WGLContext;
import sun.java2d.opengl.WGLOffScreenImage;
import sun.java2d.opengl.WGLSurfaceData;

public class WGLGraphicsConfig
extends Win32GraphicsConfig {
    protected static boolean wglAvailable;
    private static ImageCapabilities imageCaps;
    protected boolean doubleBuffer;
    protected boolean blendPremultAvailable;
    protected boolean texNonPow2Available;
    private BufferCapabilities bufferCaps;
    private long pConfigInfo;
    private ThreadLocal<OGLContext> contextTls = new ThreadLocal<OGLContext>(){

        @Override
        protected OGLContext initialValue() {
            return new WGLContext(WGLGraphicsConfig.this);
        }
    };
    private static ThreadLocal<Long> sharedContextTls;

    public static native int getDefaultPixFmt(int var0);

    private static native boolean initWGL();

    private static native long getWGLConfigInfo(int var0, int var1);

    private static native boolean isDoubleBuffered(long var0);

    private static native boolean isBlendPremultAvailable(long var0);

    private static native boolean isTexNonPow2Available(long var0);

    protected WGLGraphicsConfig(Win32GraphicsDevice win32GraphicsDevice, int n, boolean bl, long l) {
        super(win32GraphicsDevice, n);
        this.pConfigInfo = l;
        this.doubleBuffer = bl;
        this.blendPremultAvailable = WGLGraphicsConfig.isBlendPremultAvailable(l);
        this.texNonPow2Available = WGLGraphicsConfig.isTexNonPow2Available(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WGLGraphicsConfig getConfig(Win32GraphicsDevice win32GraphicsDevice, int n) {
        if (!wglAvailable) {
            return null;
        }
        long l = 0L;
        Object object = OGLContext.LOCK;
        synchronized (object) {
            l = WGLGraphicsConfig.getWGLConfigInfo(win32GraphicsDevice.getScreen(), n);
        }
        if (l == 0L) {
            return null;
        }
        boolean bl = WGLGraphicsConfig.isDoubleBuffered(l);
        return new WGLGraphicsConfig(win32GraphicsDevice, n, bl, l);
    }

    public static boolean isWGLAvailable() {
        return wglAvailable;
    }

    public boolean isBlendPremultAvailable() {
        return this.blendPremultAvailable;
    }

    public boolean isTexNonPow2Available() {
        return this.texNonPow2Available;
    }

    public boolean isDoubleBuffered() {
        return this.doubleBuffer;
    }

    public long getNativeConfigInfo() {
        return this.pConfigInfo;
    }

    public final OGLContext getContext() {
        return this.contextTls.get();
    }

    private static native long initNativeSharedContext();

    private static native long makeNativeSharedContextCurrent(long var0);

    public static long getThreadSharedContext() {
        long l = sharedContextTls.get();
        return WGLGraphicsConfig.makeNativeSharedContextCurrent(l);
    }

    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                return new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
        }
        return null;
    }

    public String toString() {
        return "WGLGraphicsConfig[dev=" + this.screen + ",pixfmt=" + this.visual + "]";
    }

    public SurfaceData createSurfaceData(WComponentPeer wComponentPeer, int n) {
        return WGLSurfaceData.createData(wComponentPeer);
    }

    public Image createAcceleratedImage(Component component, int n, int n2) {
        ColorModel colorModel = this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new WGLOffScreenImage(component, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    private native void swapBuffers(long var1);

    public void assertOperationSupported(Component component, int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities bufferCapabilities2 = this.getBufferCapabilities();
        if (!bufferCapabilities2.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (bufferCapabilities.getFlipContents() == BufferCapabilities.FlipContents.PRIOR) {
            throw new AWTException("FlipContents.PRIOR is not supported");
        }
    }

    public VolatileImage createBackBuffer(WComponentPeer wComponentPeer) {
        Component component = (Component)wComponentPeer.getTarget();
        return new SunVolatileImage(component, component.getWidth(), component.getHeight(), Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flip(WComponentPeer wComponentPeer, Component component, VolatileImage volatileImage, BufferCapabilities.FlipContents flipContents) {
        long l = wComponentPeer.getData();
        if (flipContents == BufferCapabilities.FlipContents.COPIED) {
            Graphics graphics = wComponentPeer.getGraphics();
            try {
                graphics.drawImage(volatileImage, 0, 0, null);
            }
            finally {
                graphics.dispose();
            }
            return;
        }
        if (flipContents == BufferCapabilities.FlipContents.PRIOR) {
            return;
        }
        Object object = OGLContext.LOCK;
        synchronized (object) {
            this.swapBuffers(l);
        }
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            object = volatileImage.getGraphics();
            try {
                ((Graphics)object).setColor(component.getBackground());
                ((Graphics)object).fillRect(0, 0, volatileImage.getWidth(), volatileImage.getHeight());
            }
            finally {
                ((Graphics)object).dispose();
            }
        }
    }

    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = new WGLCapabilities(this.doubleBuffer);
        }
        return this.bufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        imageCaps = new ImageCapabilities(true);
        OGLContext.LOCK = Win32GraphicsEnvironment.class;
        Object object = OGLContext.LOCK;
        synchronized (object) {
            wglAvailable = WGLGraphicsConfig.initWGL();
        }
        sharedContextTls = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                return new Long(WGLGraphicsConfig.initNativeSharedContext());
            }
        };
    }

    private static class WGLCapabilities
    extends BufferCapabilities {
        public WGLCapabilities(boolean bl) {
            super(imageCaps, imageCaps, bl ? BufferCapabilities.FlipContents.UNDEFINED : null);
        }
    }
}

