/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SystemEventQueueUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.RootPaneUI;

public class JRootPane
extends JComponent
implements Accessible {
    private static final String uiClassID = "RootPaneUI";
    public static final int NONE = 0;
    public static final int FRAME = 1;
    public static final int PLAIN_DIALOG = 2;
    public static final int INFORMATION_DIALOG = 3;
    public static final int ERROR_DIALOG = 4;
    public static final int COLOR_CHOOSER_DIALOG = 5;
    public static final int FILE_CHOOSER_DIALOG = 6;
    public static final int QUESTION_DIALOG = 7;
    public static final int WARNING_DIALOG = 8;
    private Component mostRecentFocusOwner;
    private int windowDecorationStyle;
    protected JMenuBar menuBar;
    protected Container contentPane;
    protected JLayeredPane layeredPane;
    protected Component glassPane;
    protected JButton defaultButton;
    @Deprecated
    protected DefaultAction defaultPressAction;
    @Deprecated
    protected DefaultAction defaultReleaseAction;

    public JRootPane() {
        this.setGlassPane(this.createGlassPane());
        this.setLayeredPane(this.createLayeredPane());
        this.setContentPane(this.createContentPane());
        this.setLayout(this.createRootLayout());
        this.setDoubleBuffered(true);
        this.updateUI();
    }

    public int getWindowDecorationStyle() {
        return this.windowDecorationStyle;
    }

    public void setWindowDecorationStyle(int n) {
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("Invalid decoration style");
        }
        int n2 = this.getWindowDecorationStyle();
        this.windowDecorationStyle = n;
        this.firePropertyChange("windowDecorationStyle", n2, n);
    }

    public RootPaneUI getUI() {
        return (RootPaneUI)this.ui;
    }

    public void setUI(RootPaneUI rootPaneUI) {
        super.setUI(rootPaneUI);
    }

    public void updateUI() {
        this.setUI((RootPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected JLayeredPane createLayeredPane() {
        JLayeredPane jLayeredPane = new JLayeredPane();
        jLayeredPane.setName(this.getName() + ".layeredPane");
        return jLayeredPane;
    }

    protected Container createContentPane() {
        JPanel jPanel = new JPanel();
        jPanel.setName(this.getName() + ".contentPane");
        jPanel.setLayout(new BorderLayout(){

            public void addLayoutComponent(Component component, Object object) {
                if (object == null) {
                    object = "Center";
                }
                super.addLayoutComponent(component, object);
            }
        });
        return jPanel;
    }

    protected Component createGlassPane() {
        JPanel jPanel = new JPanel();
        jPanel.setName(this.getName() + ".glassPane");
        jPanel.setVisible(false);
        jPanel.setOpaque(false);
        return jPanel;
    }

    protected LayoutManager createRootLayout() {
        return new RootLayout();
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        if (this.menuBar != null && this.menuBar.getParent() == this.layeredPane) {
            this.layeredPane.remove(this.menuBar);
        }
        this.menuBar = jMenuBar;
        if (this.menuBar != null) {
            this.layeredPane.add((Component)this.menuBar, JLayeredPane.FRAME_CONTENT_LAYER);
        }
    }

    @Deprecated
    public void setMenuBar(JMenuBar jMenuBar) {
        if (this.menuBar != null && this.menuBar.getParent() == this.layeredPane) {
            this.layeredPane.remove(this.menuBar);
        }
        this.menuBar = jMenuBar;
        if (this.menuBar != null) {
            this.layeredPane.add((Component)this.menuBar, JLayeredPane.FRAME_CONTENT_LAYER);
        }
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    @Deprecated
    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setContentPane(Container container) {
        if (container == null) {
            throw new IllegalComponentStateException("contentPane cannot be set to null.");
        }
        if (this.contentPane != null && this.contentPane.getParent() == this.layeredPane) {
            this.layeredPane.remove(this.contentPane);
        }
        this.contentPane = container;
        this.layeredPane.add((Component)this.contentPane, JLayeredPane.FRAME_CONTENT_LAYER);
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        if (jLayeredPane == null) {
            throw new IllegalComponentStateException("layeredPane cannot be set to null.");
        }
        if (this.layeredPane != null && this.layeredPane.getParent() == this) {
            this.remove(this.layeredPane);
        }
        this.layeredPane = jLayeredPane;
        this.add((Component)this.layeredPane, -1);
    }

    public JLayeredPane getLayeredPane() {
        return this.layeredPane;
    }

    public void setGlassPane(Component component) {
        if (component == null) {
            throw new NullPointerException("glassPane cannot be set to null.");
        }
        boolean bl = false;
        if (this.glassPane != null && this.glassPane.getParent() == this) {
            this.remove(this.glassPane);
            bl = this.glassPane.isVisible();
        }
        component.setVisible(bl);
        this.glassPane = component;
        this.add(this.glassPane, 0);
        if (bl) {
            this.repaint();
        }
    }

    public Component getGlassPane() {
        return this.glassPane;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public boolean isOptimizedDrawingEnabled() {
        return !this.glassPane.isVisible();
    }

    public void addNotify() {
        SystemEventQueueUtilities.addRunnableCanvas(this);
        super.addNotify();
        this.enableEvents(8L);
    }

    public void removeNotify() {
        SystemEventQueueUtilities.removeRunnableCanvas(this);
        super.removeNotify();
    }

    public void setDefaultButton(JButton jButton) {
        JButton jButton2 = this.defaultButton;
        if (jButton2 != jButton) {
            this.defaultButton = jButton;
            if (jButton2 != null) {
                jButton2.repaint();
            }
            if (jButton != null) {
                jButton.repaint();
            }
        }
        this.firePropertyChange("defaultButton", jButton2, jButton);
    }

    public JButton getDefaultButton() {
        return this.defaultButton;
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        if (this.glassPane != null && this.glassPane.getParent() == this && this.getComponent(0) != this.glassPane) {
            this.add(this.glassPane, 0);
        }
    }

    void setMostRecentFocusOwner(Component component) {
        this.mostRecentFocusOwner = component;
    }

    Component getMostRecentFocusOwner() {
        return this.mostRecentFocusOwner;
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJRootPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJRootPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJRootPane() {
            super(JRootPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ROOT_PANE;
        }

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount();
        }

        public Accessible getAccessibleChild(int n) {
            return super.getAccessibleChild(n);
        }
    }

    static class DefaultAction
    extends AbstractAction {
        JButton owner;
        JRootPane root;
        boolean press;

        DefaultAction(JRootPane jRootPane, boolean bl) {
            this.root = jRootPane;
            this.press = bl;
        }

        public void setOwner(JButton jButton) {
            this.owner = jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.owner != null && SwingUtilities.getRootPane(this.owner) == this.root) {
                ButtonModel buttonModel = this.owner.getModel();
                if (this.press) {
                    buttonModel.setArmed(true);
                    buttonModel.setPressed(true);
                } else {
                    buttonModel.setPressed(false);
                }
            }
        }

        public boolean isEnabled() {
            return this.owner.getModel().isEnabled();
        }
    }

    protected class RootLayout
    implements LayoutManager2,
    Serializable {
        protected RootLayout() {
        }

        public Dimension preferredLayoutSize(Container container) {
            Insets insets = JRootPane.this.getInsets();
            Dimension dimension = JRootPane.this.contentPane != null ? JRootPane.this.contentPane.getPreferredSize() : container.getSize();
            Dimension dimension2 = JRootPane.this.menuBar != null && JRootPane.this.menuBar.isVisible() ? JRootPane.this.menuBar.getPreferredSize() : new Dimension(0, 0);
            return new Dimension(Math.max(dimension.width, dimension2.width) + insets.left + insets.right, dimension.height + dimension2.height + insets.top + insets.bottom);
        }

        public Dimension minimumLayoutSize(Container container) {
            Insets insets = JRootPane.this.getInsets();
            Dimension dimension = JRootPane.this.contentPane != null ? JRootPane.this.contentPane.getMinimumSize() : container.getSize();
            Dimension dimension2 = JRootPane.this.menuBar != null && JRootPane.this.menuBar.isVisible() ? JRootPane.this.menuBar.getMinimumSize() : new Dimension(0, 0);
            return new Dimension(Math.max(dimension.width, dimension2.width) + insets.left + insets.right, dimension.height + dimension2.height + insets.top + insets.bottom);
        }

        public Dimension maximumLayoutSize(Container container) {
            Insets insets = JRootPane.this.getInsets();
            Dimension dimension = JRootPane.this.menuBar != null && JRootPane.this.menuBar.isVisible() ? JRootPane.this.menuBar.getMaximumSize() : new Dimension(0, 0);
            Dimension dimension2 = JRootPane.this.contentPane != null ? JRootPane.this.contentPane.getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - insets.top - insets.bottom - dimension.height - 1);
            return new Dimension(Math.min(dimension2.width, dimension.width) + insets.left + insets.right, dimension2.height + dimension.height + insets.top + insets.bottom);
        }

        public void layoutContainer(Container container) {
            Rectangle rectangle = container.getBounds();
            Insets insets = JRootPane.this.getInsets();
            int n = 0;
            int n2 = rectangle.width - insets.right - insets.left;
            int n3 = rectangle.height - insets.top - insets.bottom;
            if (JRootPane.this.layeredPane != null) {
                JRootPane.this.layeredPane.setBounds(insets.left, insets.top, n2, n3);
            }
            if (JRootPane.this.glassPane != null) {
                JRootPane.this.glassPane.setBounds(insets.left, insets.top, n2, n3);
            }
            if (JRootPane.this.menuBar != null && JRootPane.this.menuBar.isVisible()) {
                Dimension dimension = JRootPane.this.menuBar.getPreferredSize();
                JRootPane.this.menuBar.setBounds(0, 0, n2, dimension.height);
                n += dimension.height;
            }
            if (JRootPane.this.contentPane != null) {
                JRootPane.this.contentPane.setBounds(0, n, n2, n3 - n);
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }
    }
}

