/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.util;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.remote.util.ClassLogger;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvHelp {
    private static final String DEFAULT_CLASS_LOADER = "jmx.remote.default.class.loader";
    private static final String DEFAULT_CLASS_LOADER_NAME = "jmx.remote.default.class.loader.name";
    public static final String BUFFER_SIZE_PROPERTY = "jmx.remote.x.notification.buffer.size";
    public static final String MAX_FETCH_NOTIFS = "jmx.remote.x.notification.fetch.max";
    public static final String FETCH_TIMEOUT = "jmx.remote.x.notification.fetch.timeout";
    public static final String DEFAULT_ORB = "java.naming.corba.orb";
    public static final String HIDDEN_ATTRIBUTES = "jmx.remote.x.hidden.attributes";
    public static final String DEFAULT_HIDDEN_ATTRIBUTES = "java.naming.security.* jmx.remote.authenticator jmx.remote.context jmx.remote.default.class.loader jmx.remote.message.connection.server jmx.remote.object.wrapping jmx.remote.rmi.client.socket.factory jmx.remote.rmi.server.socket.factory jmx.remote.sasl.callback.handler jmx.remote.tls.socket.factory jmx.remote.x.access.file jmx.remote.x.password.file ";
    private static final SortedSet defaultHiddenStrings = new TreeSet();
    private static final SortedSet defaultHiddenPrefixes = new TreeSet();
    public static final String SERVER_CONNECTION_TIMEOUT = "jmx.remote.x.server.connection.timeout";
    public static final String CLIENT_CONNECTION_CHECK_PERIOD = "jmx.remote.x.client.connection.check.period";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "EnvHelp");

    public static ClassLoader resolveServerClassLoader(Map map, MBeanServer mBeanServer) throws InstanceNotFoundException {
        if (map == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        Object v = map.get(DEFAULT_CLASS_LOADER);
        Object v2 = map.get(DEFAULT_CLASS_LOADER_NAME);
        if (v != null && v2 != null) {
            throw new IllegalArgumentException("Only one of jmx.remote.default.class.loader or jmx.remote.default.class.loader.name should be specified.");
        }
        if (v == null && v2 == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        if (v != null) {
            if (v instanceof ClassLoader) {
                return (ClassLoader)v;
            }
            String string = "ClassLoader object is not an instance of " + ClassLoader.class.getName() + " : " + v.getClass().getName();
            throw new IllegalArgumentException(string);
        }
        if (!(v2 instanceof ObjectName)) {
            String string = "ClassLoader name is not an instance of " + ObjectName.class.getName() + " : " + v2.getClass().getName();
            throw new IllegalArgumentException(string);
        }
        ObjectName objectName = (ObjectName)v2;
        if (mBeanServer == null) {
            throw new IllegalArgumentException("Null MBeanServer object");
        }
        return mBeanServer.getClassLoader(objectName);
    }

    public static ClassLoader resolveClientClassLoader(Map map) {
        if (map == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        Object v = map.get(DEFAULT_CLASS_LOADER);
        if (v == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        if (v instanceof ClassLoader) {
            return (ClassLoader)v;
        }
        String string = "ClassLoader object is not an instance of " + ClassLoader.class.getName() + " : " + v.getClass().getName();
        throw new IllegalArgumentException(string);
    }

    public static <T extends Throwable> T initCause(T t, Throwable throwable) {
        t.initCause(throwable);
        return t;
    }

    public static Throwable getCause(Throwable throwable) {
        Throwable throwable2 = throwable;
        try {
            Method method = throwable.getClass().getMethod("getCause", null);
            throwable2 = (Throwable)method.invoke(throwable, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return throwable2 != null ? throwable2 : throwable;
    }

    public static int getNotifBufferSize(Map map) {
        int n = 1000;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction(BUFFER_SIZE_PROPERTY);
            String string = (String)AccessController.doPrivileged(getPropertyAction);
            if (string != null) {
                n = Integer.parseInt(string);
            } else {
                getPropertyAction = new GetPropertyAction("jmx.remote.x.buffer.size");
                string = (String)AccessController.doPrivileged(getPropertyAction);
                if (string != null) {
                    n = Integer.parseInt(string);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            logger.warning("getNotifBufferSize", "Can't use System property jmx.remote.x.notification.buffer.size: " + runtimeException);
            logger.debug("getNotifBufferSize", runtimeException);
        }
        int n2 = n;
        try {
            n2 = map.containsKey(BUFFER_SIZE_PROPERTY) ? (int)EnvHelp.getIntegerAttribute(map, BUFFER_SIZE_PROPERTY, n, 0L, Integer.MAX_VALUE) : (int)EnvHelp.getIntegerAttribute(map, "jmx.remote.x.buffer.size", n, 0L, Integer.MAX_VALUE);
        }
        catch (RuntimeException runtimeException) {
            logger.warning("getNotifBufferSize", "Can't determine queuesize (using default): " + runtimeException);
            logger.debug("getNotifBufferSize", runtimeException);
        }
        return n2;
    }

    public static int getMaxFetchNotifNumber(Map map) {
        return (int)EnvHelp.getIntegerAttribute(map, MAX_FETCH_NOTIFS, 1000L, 1L, Integer.MAX_VALUE);
    }

    public static long getFetchTimeout(Map map) {
        return EnvHelp.getIntegerAttribute(map, FETCH_TIMEOUT, 60000L, 0L, Long.MAX_VALUE);
    }

    public static long getIntegerAttribute(Map map, String string, long l, long l2, long l3) {
        long l4;
        Object v;
        if (map == null || (v = map.get(string)) == null) {
            return l;
        }
        if (v instanceof Number) {
            l4 = ((Number)v).longValue();
        } else if (v instanceof String) {
            l4 = Long.parseLong((String)v);
        } else {
            String string2 = "Attribute " + string + " value must be Integer or String: " + v;
            throw new IllegalArgumentException(string2);
        }
        if (l4 < l2) {
            String string3 = "Attribute " + string + " value must be at least " + l2 + ": " + l4;
            throw new IllegalArgumentException(string3);
        }
        if (l4 > l3) {
            String string4 = "Attribute " + string + " value must be at most " + l3 + ": " + l4;
            throw new IllegalArgumentException(string4);
        }
        return l4;
    }

    public static void checkAttributes(Map map) {
        for (Object k : map.keySet()) {
            if (k instanceof String) continue;
            String string = "Attributes contain key that is not a string: " + k;
            throw new IllegalArgumentException(string);
        }
    }

    public static Map filterAttributes(Map map) {
        if (logger.traceOn()) {
            logger.trace("filterAttributes", "starts");
        }
        TreeMap treeMap = new TreeMap(map);
        EnvHelp.purgeUnserializable(treeMap.values());
        EnvHelp.hideAttributes(treeMap);
        return treeMap;
    }

    private static void purgeUnserializable(Collection collection) {
        logger.trace("purgeUnserializable", "starts");
        ObjectOutputStream objectOutputStream = null;
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null || e instanceof String) {
                if (logger.traceOn()) {
                    logger.trace("purgeUnserializable", "Value trivially serializable: " + e);
                }
            } else {
                try {
                    if (objectOutputStream == null) {
                        objectOutputStream = new ObjectOutputStream(new SinkOutputStream());
                    }
                    objectOutputStream.writeObject(e);
                    if (logger.traceOn()) {
                        logger.trace("purgeUnserializable", "Value serializable: " + e);
                    }
                }
                catch (IOException iOException) {
                    if (logger.traceOn()) {
                        logger.trace("purgeUnserializable", "Value not serializable: " + e + ": " + iOException);
                    }
                    iterator.remove();
                    objectOutputStream = null;
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void hideAttributes(SortedMap sortedMap) {
        Object object;
        TreeSet treeSet;
        TreeSet treeSet2;
        if (sortedMap.isEmpty()) {
            return;
        }
        String string = (String)sortedMap.get(HIDDEN_ATTRIBUTES);
        if (string != null) {
            string = string.startsWith("=") ? string.substring(1) : string + " java.naming.security.* jmx.remote.authenticator jmx.remote.context jmx.remote.default.class.loader jmx.remote.message.connection.server jmx.remote.object.wrapping jmx.remote.rmi.client.socket.factory jmx.remote.rmi.server.socket.factory jmx.remote.sasl.callback.handler jmx.remote.tls.socket.factory jmx.remote.x.access.file jmx.remote.x.password.file ";
            treeSet2 = new TreeSet();
            treeSet = new TreeSet();
            EnvHelp.parseHiddenAttributes(string, treeSet2, treeSet);
        } else {
            string = DEFAULT_HIDDEN_ATTRIBUTES;
            object = defaultHiddenStrings;
            synchronized (object) {
                if (defaultHiddenStrings.isEmpty()) {
                    EnvHelp.parseHiddenAttributes(string, defaultHiddenStrings, defaultHiddenPrefixes);
                }
                treeSet2 = defaultHiddenStrings;
                treeSet = defaultHiddenPrefixes;
            }
        }
        object = sortedMap.lastKey() + "X";
        Iterator iterator = sortedMap.keySet().iterator();
        Iterator iterator2 = treeSet2.iterator();
        Iterator iterator3 = treeSet.iterator();
        Object object2 = iterator2.hasNext() ? (String)iterator2.next() : object;
        Object object3 = iterator3.hasNext() ? (String)iterator3.next() : object;
        block3: while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            int n = 1;
            while ((n = ((String)object2).compareTo(string2)) < 0) {
                if (iterator2.hasNext()) {
                    object2 = (String)iterator2.next();
                    continue;
                }
                object2 = object;
            }
            if (n == 0) {
                iterator.remove();
                continue;
            }
            while (((String)object3).compareTo(string2) <= 0) {
                if (string2.startsWith((String)object3)) {
                    iterator.remove();
                    continue block3;
                }
                if (iterator3.hasNext()) {
                    object3 = (String)iterator3.next();
                    continue;
                }
                object3 = object;
            }
        }
    }

    private static void parseHiddenAttributes(String string, SortedSet sortedSet, SortedSet sortedSet2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.endsWith("*")) {
                sortedSet2.add(string2.substring(0, string2.length() - 1));
                continue;
            }
            sortedSet.add(string2);
        }
    }

    public static long getServerConnectionTimeout(Map map) {
        return EnvHelp.getIntegerAttribute(map, SERVER_CONNECTION_TIMEOUT, 120000L, 0L, Long.MAX_VALUE);
    }

    public static long getConnectionCheckPeriod(Map map) {
        return EnvHelp.getIntegerAttribute(map, CLIENT_CONNECTION_CHECK_PERIOD, 60000L, 0L, Long.MAX_VALUE);
    }

    public static Hashtable mapToHashtable(Map map) {
        HashMap hashMap = new HashMap(map);
        if (hashMap.containsKey(null)) {
            hashMap.remove(null);
        }
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
        return new Hashtable(hashMap);
    }

    private static final class SinkOutputStream
    extends OutputStream {
        private SinkOutputStream() {
        }

        public void write(byte[] byArray, int n, int n2) {
        }

        public void write(int n) {
        }
    }
}

