/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.IOException;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import sun.tools.jconsole.BorderedComponent;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.TimeComboBox;
import sun.tools.jconsole.VMPanel;
import sun.tools.jconsole.VariableGridLayout;

class ThreadTab
extends Tab
implements DocumentListener,
ListSelectionListener {
    PlotterPanel threadMeter;
    TimeComboBox timeComboBox;
    DefaultListModel listModel;
    JList list;
    JTextArea textArea;
    JTextField filterTF;
    HashMap<Long, String> nameCache = new HashMap();
    private static final String threadCountKey = "threadCount";
    private static final String peakKey = "peak";
    private static final String totalKey = "total";
    private static final String threadCountName = Resources.getText("Live Threads", new Object[0]);
    private static final String peakName = Resources.getText("Peak", new Object[0]);
    private static final String totalName = Resources.getText("Total Started", new Object[0]);
    private static final Color threadCountColor = Plotter.defaultColor;
    private static final Color peakColor = Color.red;
    private static final Color totalColor = Color.magenta;
    private long[] oldThreads = new long[0];
    long lastSelected = -1L;

    public static String getTabName() {
        return Resources.getText("Threads", new Object[0]);
    }

    public ThreadTab(VMPanel vMPanel) {
        super(vMPanel, ThreadTab.getTabName());
        this.setLayout(new BorderLayout(4, 4));
        this.setBorder(new EmptyBorder(4, 4, 3, 4));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new VariableGridLayout(0, 1, 4, 4, true, true));
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 10));
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 20, 5));
        jPanel.add((Component)jPanel4, "Center");
        this.threadMeter = new PlotterPanel(Resources.getText("Number of Threads", new Object[0]), false, true);
        this.threadMeter.plotter.createSequence(threadCountKey, threadCountName, threadCountColor, true);
        this.threadMeter.plotter.createSequence(peakKey, peakName, peakColor, true);
        this.threadMeter.plotter.createSequence(totalKey, totalName, totalColor, true);
        jPanel2.add(this.threadMeter);
        this.timeComboBox = new TimeComboBox(this.threadMeter.plotter);
        jPanel4.add(new LabeledComponent(Resources.getText("Time Range:", new Object[0]), this.timeComboBox));
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel){
            {
                this.addListSelectionListener(ThreadTab.this);
                this.setCellRenderer(new DefaultListCellRenderer(){

                    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                        super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                        if (object != null) {
                            String string = ThreadTab.this.nameCache.get(object);
                            if (string == null) {
                                string = object.toString();
                            }
                            this.setText(string);
                        }
                        return this;
                    }
                });
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = Math.max(dimension.width, 100);
                return dimension;
            }
        };
        this.textArea = new JTextArea();
        jPanel3.add((Component)new JScrollPane(this.list), "West");
        jPanel3.add((Component)new JScrollPane(this.textArea), "Center");
        this.filterTF = new JTextField(20);
        this.filterTF.getDocument().addDocumentListener(this);
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        jPanel5.add(new LabeledComponent(Resources.getText("Filter: ", new Object[0]), this.filterTF));
        jPanel3.add((Component)jPanel5, "South");
        BorderedComponent borderedComponent = new BorderedComponent(Resources.getText("Live Threads", new Object[0]), jPanel3, true);
        jPanel2.add(borderedComponent);
        LabeledComponent.layout(jPanel2);
    }

    public void update() {
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        try {
            final ThreadMXBean threadMXBean = proxyClient.getThreadMXBean();
            final int n = threadMXBean.getThreadCount();
            this.threadMeter.plotter.addValue(threadCountKey, n);
            int n2 = threadMXBean.getPeakThreadCount();
            this.threadMeter.plotter.addValue(peakKey, n2);
            long l = threadMXBean.getTotalStartedThreadCount();
            this.threadMeter.plotter.addValue(totalKey, l);
            final long[] lArray = threadMXBean.getAllThreadIds();
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ThreadTab.this.threadMeter.setValueLabel(n + "");
                    String string = ThreadTab.this.filterTF.getText();
                    boolean bl = string.length() > 0;
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    for (long l : lArray) {
                        arrayList.add(l);
                    }
                    Object object = arrayList.iterator();
                    while (object.hasNext()) {
                        ThreadInfo threadInfo;
                        long l = (Long)object.next();
                        String string2 = ThreadTab.this.nameCache.get(l);
                        if (string2 == null && (threadInfo = threadMXBean.getThreadInfo(l)) != null && (string2 = threadInfo.getThreadName()) != null) {
                            ThreadTab.this.nameCache.put(l, string2);
                        }
                        if (!bl || string2 == null || string2.indexOf(string) >= 0) continue;
                        object.remove();
                    }
                    long[] lArray2 = lArray;
                    if (arrayList.size() < lArray.length) {
                        lArray2 = new long[arrayList.size()];
                        for (int i = 0; i < lArray2.length; ++i) {
                            lArray2[i] = (Long)arrayList.get(i);
                        }
                    }
                    for (long l : ThreadTab.this.oldThreads) {
                        int n2 = 0;
                        for (long l2 : lArray2) {
                            if (l2 != l) continue;
                            n2 = 1;
                            break;
                        }
                        if (n2 != 0) continue;
                        ThreadTab.this.listModel.removeElement(l);
                        if (bl) continue;
                        ThreadTab.this.nameCache.remove(l);
                    }
                    for (int i = lArray2.length - 1; i >= 0; --i) {
                        long l = lArray2[i];
                        boolean bl2 = false;
                        for (long l3 : ThreadTab.this.oldThreads) {
                            if (l != l3) continue;
                            bl2 = true;
                            break;
                        }
                        if (bl2) continue;
                        ThreadTab.this.listModel.addElement(l);
                    }
                    ThreadTab.access$002(ThreadTab.this, lArray2);
                }
            });
        }
        catch (IOException iOException) {
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            proxyClient.markAsDead();
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Long l = (Long)this.list.getSelectedValue();
        if (l == null) {
            if (this.lastSelected != -1L) {
                l = this.lastSelected;
            }
        } else {
            this.lastSelected = l;
        }
        this.textArea.setText("");
        if (l != null) {
            final long l2 = l;
            this.workerAdd(new Runnable(){

                public void run() {
                    Object object;
                    ProxyClient proxyClient = ThreadTab.this.vmPanel.getProxyClient();
                    StringBuilder stringBuilder = new StringBuilder();
                    try {
                        object = proxyClient.getThreadMXBean();
                        ThreadInfo threadInfo = object.getThreadInfo(l2, Integer.MAX_VALUE);
                        if (threadInfo != null) {
                            if (threadInfo.getLockName() == null) {
                                stringBuilder.append(Resources.getText("Name State", threadInfo.getThreadName(), threadInfo.getThreadState().toString()));
                            } else if (threadInfo.getLockOwnerName() == null) {
                                stringBuilder.append(Resources.getText("Name State LockName", threadInfo.getThreadName(), threadInfo.getThreadState().toString(), threadInfo.getLockName()));
                            } else {
                                stringBuilder.append(Resources.getText("Name State LockName LockOwner", threadInfo.getThreadName(), threadInfo.getThreadState().toString(), threadInfo.getLockName(), threadInfo.getLockOwnerName()));
                            }
                            stringBuilder.append(Resources.getText("BlockedCount WaitedCount", threadInfo.getBlockedCount(), threadInfo.getWaitedCount()));
                            stringBuilder.append(Resources.getText("Stack trace", new Object[0]));
                            for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
                                stringBuilder.append(stackTraceElement.toString() + "\n");
                            }
                        }
                    }
                    catch (IOException iOException) {
                    }
                    catch (UndeclaredThrowableException undeclaredThrowableException) {
                        proxyClient.markAsDead();
                    }
                    object = stringBuilder.toString();
                    SwingUtilities.invokeLater(new Runnable((String)object){
                        final /* synthetic */ String val$text;
                        {
                            this.val$text = string;
                        }

                        public void run() {
                            ThreadTab.this.textArea.setText(this.val$text);
                            ThreadTab.this.textArea.setCaretPosition(0);
                        }
                    });
                }
            });
        }
    }

    private void doUpdate() {
        this.workerAdd(new Runnable(){

            public void run() {
                ThreadTab.this.update();
            }
        });
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.doUpdate();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.doUpdate();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.doUpdate();
    }

    static /* synthetic */ long[] access$002(ThreadTab threadTab, long[] lArray) {
        threadTab.oldThreads = lArray;
        return lArray;
    }
}

