/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultCaret;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.TimeComboBox;
import sun.tools.jconsole.VMPanel;

class ClassTab
extends Tab
implements ActionListener {
    PlotterPanel loadedClassesMeter;
    TimeComboBox timeComboBox;
    private JCheckBox verboseCheckBox;
    private JEditorPane details;
    private static final String loadedPlotterKey = "loaded";
    private static final String totalLoadedPlotterKey = "totalLoaded";
    private static final String loadedPlotterName = Resources.getText("Loaded", new Object[0]);
    private static final String totalLoadedPlotterName = Resources.getText("Total Loaded", new Object[0]);
    private static final Color loadedPlotterColor = Plotter.defaultColor;
    private static final Color totalLoadedPlotterColor = Color.red;

    public static String getTabName() {
        return Resources.getText("Classes", new Object[0]);
    }

    public ClassTab(VMPanel vMPanel) {
        super(vMPanel, ClassTab.getTabName());
        this.setLayout(new BorderLayout(4, 4));
        this.setBorder(new EmptyBorder(4, 4, 3, 4));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 20, 5));
        jPanel.add((Component)jPanel4, "Center");
        this.verboseCheckBox = new JCheckBox(Resources.getText("Verbose Output", new Object[0]));
        this.verboseCheckBox.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new EmptyBorder(0, 57, 0, 70));
        jPanel5.add(this.verboseCheckBox);
        jPanel.add((Component)jPanel5, "After");
        this.loadedClassesMeter = new PlotterPanel(Resources.getText("Number of Loaded Classes", new Object[0]), false, false);
        this.loadedClassesMeter.plotter.createSequence(loadedPlotterKey, loadedPlotterName, loadedPlotterColor, true);
        this.loadedClassesMeter.plotter.createSequence(totalLoadedPlotterKey, totalLoadedPlotterName, totalLoadedPlotterColor, true);
        jPanel2.add(this.loadedClassesMeter);
        this.timeComboBox = new TimeComboBox(this.loadedClassesMeter.plotter);
        jPanel4.add(new LabeledComponent(Resources.getText("Time Range:", new Object[0]), this.timeComboBox));
        LabeledComponent.layout(jPanel2);
        jPanel3.setBorder(new CompoundBorder(new TitledBorder(Resources.getText("Details", new Object[0])), new EmptyBorder(10, 10, 10, 10)));
        this.details = new JEditorPane();
        this.details.setContentType("text/html");
        this.details.setEditable(false);
        ((DefaultCaret)this.details.getCaret()).setUpdatePolicy(1);
        JScrollPane jScrollPane = new JScrollPane(this.details);
        jScrollPane.setPreferredSize(new Dimension(0, 150));
        jPanel3.add((Component)jScrollPane, "South");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final boolean bl = this.verboseCheckBox.isSelected();
        this.workerAdd(new Runnable(){

            public void run() {
                ProxyClient proxyClient = ClassTab.this.vmPanel.getProxyClient();
                try {
                    proxyClient.getClassLoadingMXBean().setVerbose(bl);
                }
                catch (UndeclaredThrowableException undeclaredThrowableException) {
                    proxyClient.markAsDead();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public void update() {
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        try {
            ClassLoadingMXBean classLoadingMXBean = proxyClient.getClassLoadingMXBean();
            final long l = classLoadingMXBean.getLoadedClassCount();
            this.loadedClassesMeter.plotter.addValue(loadedPlotterKey, l);
            long l2 = classLoadingMXBean.getTotalLoadedClassCount();
            this.loadedClassesMeter.plotter.addValue(totalLoadedPlotterKey, l2);
            final boolean bl = classLoadingMXBean.isVerbose();
            final String string = this.formatDetails(classLoadingMXBean);
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ClassTab.this.loadedClassesMeter.setValueLabel(l + "");
                    ClassTab.this.verboseCheckBox.setSelected(bl);
                    ClassTab.this.details.setText(string);
                }
            });
        }
        catch (IOException iOException) {
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            proxyClient.markAsDead();
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String formatDetails(ClassLoadingMXBean classLoadingMXBean) {
        String string = "<html><table cellspacing=0 cellpadding=0>";
        long l = System.currentTimeMillis();
        String string2 = Formatter.formatDateTime(l);
        string = string + Formatter.newRow(Resources.getText("Time", new Object[0]), string2);
        long l2 = classLoadingMXBean.getLoadedClassCount();
        long l3 = classLoadingMXBean.getUnloadedClassCount();
        long l4 = classLoadingMXBean.getTotalLoadedClassCount();
        string = string + Formatter.newRow(Resources.getText("Current classes loaded", new Object[0]), Formatter.justify(l2, 5));
        string = string + Formatter.newRow(Resources.getText("Total classes loaded", new Object[0]), Formatter.justify(l4, 5));
        string = string + Formatter.newRow(Resources.getText("Total classes unloaded", new Object[0]), Formatter.justify(l3, 5));
        return string;
    }
}

